import { Request, Response } from 'express';
/**
 * Auth Controller - Handles authentication operations
 */
export declare class AuthController {
    /**
     * Register a new user
     * POST /api/auth/signup
     */
    signup(req: Request, res: Response): Promise<Response<any, Record<string, any>> | undefined>;
    /**
     * Login user
     * POST /api/auth/login
     */
    login(req: Request, res: Response): Promise<Response<any, Record<string, any>> | undefined>;
    /**
     * Get current user profile
     * GET /api/auth/profile
     */
    getProfile(req: Request, res: Response): Promise<Response<any, Record<string, any>> | undefined>;
    /**
     * Logout user
     * POST /api/auth/logout
     */
    logout(req: Request, res: Response): Promise<Response<any, Record<string, any>> | undefined>;
}
export declare const authController: AuthController;
//# sourceMappingURL=controller.d.ts.map